#!/usr/bin/env python3
"""
Script to run the Flask app on local network for PWA testing
"""

import os
import sys
from app import app

if __name__ == '__main__':
    # Get the local IP address
    local_ip = '192.168.1.15'  # Your local IP from ipconfig
    port = 5000
    
    print("=" * 60)
    print("🚀 AL MIRAG POULTRY PWA - LOCAL NETWORK SERVER")
    print("=" * 60)
    print(f"📱 Local Access: http://localhost:{port}")
    print(f"🌐 Network Access: http://{local_ip}:{port}")
    print("=" * 60)
    print("📋 PWA Testing Instructions:")
    print("1. Open the URL on your phone/tablet browser")
    print("2. Look for the 'Install App' button in the header")
    print("3. Test offline functionality")
    print("4. Check if the app appears in your device's app list")
    print("=" * 60)
    print("⚠️  Make sure your firewall allows connections on port 5000")
    print("⚠️  All devices must be on the same WiFi network")
    print("=" * 60)
    print("Press Ctrl+C to stop the server")
    print("=" * 60)
    
    try:
        # Run the Flask app on all interfaces (0.0.0.0) so it's accessible from other devices
        app.run(
            host='0.0.0.0',  # Listen on all network interfaces
            port=port,
            debug=True,
            threaded=True
        )
    except KeyboardInterrupt:
        print("\n🛑 Server stopped by user")
    except Exception as e:
        print(f"\n❌ Error starting server: {e}")
        print("💡 Try running as administrator or check if port 5000 is available")
